/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PlayerAreaStats
implements Runnable {
    private Player player;
    private String name;
    private int size;
    private Connection conn = null;
    private String table;

    PlayerAreaStats(Connection conn, Player player, String name, int size, String table) {
        this.player = player;
        this.name = name;
        this.size = size;
        this.conn = conn;
        this.table = table;
    }

    @Override
    public void run() {
        Statement ps = null;
        ResultSet rs = null;
        try {
            try {
                this.conn.setAutoCommit(false);
                ps = this.conn.prepareStatement("SELECT `type`, SUM(`created`) AS `created`, SUM(`destroyed`) AS `destroyed` FROM ((SELECT `type`, count(`type`) AS `created`, 0 AS `destroyed` FROM `" + this.table + "` INNER JOIN `lb-players` USING (`playerid`) WHERE `playername` = ? AND x > ? AND x < ? AND z > ? AND z < ? AND `type` > 0 AND `type` != `replaced` GROUP BY `type`) UNION (SELECT `replaced` AS `type`, 0 AS `created`, count(`replaced`) AS `destroyed` FROM `" + this.table + "` INNER JOIN `lb-players` USING (`playerid`) WHERE `playername` = ? AND x > ? AND x < ? AND z > ? AND z < ? AND `replaced` > 0 AND `type` != `replaced` GROUP BY `replaced`)) AS t GROUP BY `type` ORDER BY SUM(`created`) + SUM(`destroyed`) DESC LIMIT 15", 2);
                ps.setString(1, this.name);
                ps.setInt(2, this.player.getLocation().getBlockX() - this.size);
                ps.setInt(3, this.player.getLocation().getBlockX() + this.size);
                ps.setInt(4, this.player.getLocation().getBlockZ() - this.size);
                ps.setInt(5, this.player.getLocation().getBlockZ() + this.size);
                ps.setString(6, this.name);
                ps.setInt(7, this.player.getLocation().getBlockX() - this.size);
                ps.setInt(8, this.player.getLocation().getBlockX() + this.size);
                ps.setInt(9, this.player.getLocation().getBlockZ() - this.size);
                ps.setInt(10, this.player.getLocation().getBlockZ() + this.size);
                rs = ps.executeQuery();
                this.player.sendMessage(ChatColor.DARK_AQUA + "Player " + this.name + " within " + this.size + " blocks of you: ");
                if (!rs.next()) {
                    this.player.sendMessage(ChatColor.DARK_AQUA + "No results found.");
                } else {
                    this.player.sendMessage(ChatColor.GOLD + String.format("%-6s %-6s %s", "Creat", "Destr", "Block"));
                    rs.beforeFirst();
                    while (rs.next()) {
                        this.player.sendMessage(ChatColor.GOLD + String.format("%-6d %-6d %s", rs.getInt("created"), rs.getInt("destroyed"), Material.getMaterial((int)rs.getInt("type")).toString().toLowerCase().replace('_', ' ')));
                    }
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock PlayerAreaStats] SQL exception", ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex2) {
                    LogBlock.log.log(Level.SEVERE, "[LogBlock PlayerAreaStats] SQL exception on close", ex2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock PlayerAreaStats] SQL exception on close", ex);
            }
        }
    }
}

